<!DOCTYPE html>
<html lang="fa">

<head>
  <meta charset="utf-8">
  <meta charset="<?php bloginfo('charset'); ?>" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS2 Feed" href="<?php bloginfo('rss2_url'); ?>" />
  <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
  <?php
  wp_head();
  load_theme_textdomain('liosa'); ?>
  <meta name="theme-color" content="<?php echo ot_get_option('colorbackmo', ''); ?>" />
  <style>
    .container {
      max-width: 1300px;
    }
  </style>
  
  <meta name="google-site-verification" content="0Uh3QN515HLM5cI5B2gOGSkk9b8d6hWuq4wgXZ-dteI" />
  
  <!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-SL60JR3SP2"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-SL60JR3SP2');
</script>


</head>

<body <?php body_class(); ?> id="body_blog">
  <?php get_template_part('themeplat/header/select-nav', 'navbar'); ?>
  <div id="back-to-topd" class="sticky_toolbox active back_to_top">
    <ul>
      <?php
      $display_share_back  = ot_get_option('display_share_back', false);
      if ($display_share_back  == 'on') :
      ?>
        <li>
          <a title="<?php _e('share', 'liosa'); ?>" href="#modal-12">
            <i class="fal fa-share-alt"></i>
          </a>
        </li>
      <?php
      endif;
      $display_call_back  = ot_get_option('display_call_back', false);
      if ($display_call_back  == 'on') :
      ?>
        <li>
          <a target="block" href="<?php echo ot_get_option('link_call_back_to_top'); ?>" class="compare_sticky" title="<?php echo ot_get_option('text_call_back_to_top', 'تماس'); ?>">
            <i class="fal fa-headset"></i>
          </a>
        </li>
      <?php
      endif;
      $display_profile_back  = ot_get_option('display_profile_back', false);
      if ($display_profile_back  == 'on') :
      ?>
        <li>
          <a title="<?php _e('profile', 'liosa'); ?>" href="<?php echo ot_get_option('link_profile_user'); ?>">
            <i class="fal fa-tachometer-fast"></i>
          </a>
        </li>
      <?php
      endif;
      $display_back_to_top  = ot_get_option('display_back_to_top', false);
      if ($display_back_to_top  == 'on') :
      ?>
        <li>
          <a href="#" id="scroll" class="gototop" title="<?php _e('back to top', 'liosa'); ?>"><i class="fal fa-arrow-up"></i></a>
        </li>
      <?php endif; ?>
    </ul>
  </div>
  <div data-ml-modal id="modal-12">
    <a href="#!" class="modal-overlay"></a>
    <div class="modal-dialog blog_dt modal-dialog-lg">
      <?php get_template_part('themeplat-part/product-icon-box', 'product-icon-box'); ?>
    </div>
  </div>