<?php

/**
 * Elementor Box Content Responsive Widget.
 *
 */

class Article_5 extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'article-5';
  }

  public function get_title()
  {
    return __('Article 5', 'liosa');
  }

  public function get_icon()
  {
    return 'eicon-slideshow';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }

  protected function _register_controls()
  {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', 'liosa'),
      ]
    );
    $this->add_control(
      'grid_style',
      [
        'label' => __('Grid Style', 'liosa'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('Layout 1', 'liosa'),
          '2' => esc_html__('Layout 2', 'liosa'),
        ],
      ]
    );
    $this->add_control(
      'title',
      [
        'label' => __('Title', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('Title More', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    // Post type.
    $this->add_control(
      'grid_post_type',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-tag"></i> ' . __('Post Type', 'liosa'),
        'default' => 'post',
        'options' => $this->grid_get_all_post_types(),
      ]
    );
    $this->add_control(
      'grid_items',
      [
        'type'        => \Elementor\Controls_Manager::NUMBER,
        'label'       => '<i class="fa fa-th-large"></i> ' . __('Items', 'liosa'),
        'placeholder' => __('How many items?', 'liosa'),
        'default'     => 4,
      ]
    );

    // Post categories.
    $this->add_control(
      'grid_post_categories',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-folder"></i> ' . __('Category', 'liosa'),
        'options' => $this->grid_get_all_post_type_categories('post'),
        'condition' => [
          'grid_post_type' => 'post',
        ],
      ]
    );
    $this->add_control(
      'show_more',
      [
        'label' => __('Show more', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'grid_pagination',
      [
        'label' => '<i class="fa fa-arrow-circle-right"></i> ' . __('Pagination', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => '',
      ]
    );
    // Order by.
    $this->add_control(
      'grid_order_by',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-sort"></i> ' . __('Order by', 'liosa'),
        'default' => 'date',
        'options' => [
          'date'          => __('Date', 'liosa'),
          'title'         => __('Title', 'liosa'),
          'modified'      => __('Modified date', 'liosa'),
          'comment_count' => __('Comment count', 'liosa'),
          'rand'          => __('Random', 'liosa'),
        ],
      ]
    );

    // Price.
    $this->add_control(
      'grid_content_price',
      [
        'label' => '<i class="fa fa-usd"></i> ' . __('Price', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes',
        'condition' => [
          'section_grid.grid_post_type' => 'product',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_style',
      [
        'label' => __('Style', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->end_controls_section();
  }
  private function grid_pagination_section()
  {
    $this->start_controls_section(
      'section_grid_pagination',
      [
        'label'     => __('Pagination', 'liosa'),
        'condition' => [
          'section_grid.grid_pagination' => 'yes',
        ],
      ]
    );

    // Pagination alignment.
    $this->add_responsive_control(
      'grid_pagination_alignment',
      [
        'label'     => __('Alignment', 'liosa'),
        'type'      => \Elementor\Controls_Manager::CHOOSE,
        'options'   => [
          'left'    => [
            'title' => __('Left', 'liosa'),
            'icon'  => 'fa fa-align-left',
          ],
          'center'  => [
            'title' => __('Center', 'liosa'),
            'icon'  => 'fa fa-align-center',
          ],
          'right'   => [
            'title' => __('Right', 'liosa'),
            'icon'  => 'fa fa-align-right',
          ],
        ],
        'default'   => 'center',
        'tablet_default'   => 'center',
        'mobile_default'   => 'center',
        'selectors' => [
          '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'text-align: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_section();
  }
  private function grid_pagination_style_section()
  {
    // Tab.
    $this->start_controls_section(
      'section_grid_pagination_style',
      [
        'label' => __('Pagination', 'liosa'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'section_grid.grid_pagination' => 'yes',
        ],
      ]
    );

    // Image margin.
    $this->add_control(
      'grid_pagination_style_margin',
      [
        'label'      => __('Margin', 'liosa'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors'  => [
          '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_1',
      [
        'label' => __('color layout one', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color_1one',
      [
        'label' => __('Color text author', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_2112',
      [
        'label' => __('background text author', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#e0d4d4',
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_2113',
      [
        'label' => __('background title', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#eee',
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings();
    $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
    $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';
?>
    <div class="container">
      <section class="background_box_article col-12">
        <header class="title-five">
          <a class="inner-card" href="<?php the_permalink(); ?>">
            <h4 class="Survey-title"><?php echo $settings['title']; ?></h4>
            <?php
            if ('yes' === $settings['show_more']) {
              echo '<a class="Survey-bt-mor" href="' . $settings['website_link']['url'] . '"' . $target . $nofollow . '>';
              echo $settings['title_more'];
              ''; ?>
          </a>
        <?php } ?>
        </a>
        </header>
        <?php
        $args = array();
        $args['post_status'] = 'publish';
        $args['ignore_sticky_posts'] = 1;
        if (!empty($settings['grid_post_type']) && post_type_exists($settings['grid_post_type'])) {
          $args['post_type'] = $settings['grid_post_type'];
        }
        if (!empty($settings['grid_post_categories']) && $settings['grid_post_type'] == 'post') {
          $args['category_name'] = $settings['grid_post_categories'];
        }
        if (!empty($settings['grid_product_categories']) && $settings['grid_post_type'] == 'product') {
          $args['tax_query'] = array(
            'relation' => 'AND',
            array(
              'taxonomy' => 'product_cat',
              'field' => 'slug',
              'terms' => $settings['grid_product_categories'],
            ),
          );
        }
        if (!empty($settings['grid_items']) && intval($settings['grid_items']) == $settings['grid_items']) {
          $args['posts_per_page'] = $settings['grid_items'];
        }
        if (!empty($settings['grid_order_by'])) {
          $args['orderby'] = $settings['grid_order_by'];
        }
        if (!empty($settings['grid_pagination'])) {
          $paged         = get_query_var('paged');
          if (empty($paged)) {
            $paged         = get_query_var('page');
          }
          $args['paged'] = $paged;
        }
        $query = new \WP_Query($args);
        if ($query->have_posts()) {
          while ($query->have_posts()) {
            $query->the_post();
        ?>
            <div class="col-12 col-xl-3 col-md-3 col-sm-6 col-xs-6 right">
              <div class="example-2 card-area">
                <?php
                if (get_post_thumbnail_id()) {
                  $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), array(300, 300));
                ?>
                  <div class="wrapper-box" style=" background: url('<?php echo $thumb['0']; ?>') ;background-repeat: no-repeat;background-position: center;background-size: cover;">
                  <?php
                } else { ?>
                    <div class="wrapper-box" style=" background: url('<?php print(get_template_directory_uri()); ?>/assets/images/thumb.gif') ;background-repeat: no-repeat;background-position: center;background-size: cover;">
                    <?php } ?>
                    <div class="dg-overlay-dark">
                      <div class="header">
                        <div class="date left daymonthyear">
                          <?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?>
                        </div>
                        <ul class="menu-content">
                          <li>
                            <a href="#" class="fal fa-bookmark"></a>
                          </li>
                          <li><a href="#" class="fal fa-heart"><span></span></a></li>
                          <li><a href="#comments" class="fal fa-comment"><span class="a-comment-count-bubble" data-bind="text: totalCommentsCount"><?php echo get_comments_number(); ?></span></a></li>
                        </ul>
                      </div>
                      <div class="data extranslate">
                        <div class="content">
                          <span class="author"><?php the_author(); ?></span>
                          <h2 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                          <?php echo '<p class="text">' .  get_the_excerpt() . '</p>'; ?>
                          <p style="margin-bottom:1rem"></p>
                        </div>
                      </div>
                    </div>
                    </div>
                  </div>
              </div>
            <?php
          }
          if (!empty($settings['grid_pagination'])) {
            ?>
              <div class="pagination root" style="width: 100%;">
                <?php
                $big = 999999999;
                $totalpages = $query->max_num_pages;
                $current = max(1, $paged);
                $paginate_args = array(
                  'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                  'format'    => '?paged=%#%',
                  'current'   => $current,
                  'total'     => $totalpages,
                  'show_all'  => false,
                  'end_size'  => 1,
                  'mid_size'  => 3,
                  'prev_next' => true,
                  'prev_text'          => __('<i class="fa fa-chevron-right" aria-hidden="true"></i>', 'liosa'),
                  'next_text'          => __('<i class="fa fa-chevron-left" aria-hidden="true"></i>', 'liosa'),
                  'screen_reader_text' => __('A', 'liosa')
                );
                $pagination = paginate_links($paginate_args);
                ?>
                <nav class="pagenumbers">
                  <?php echo $pagination; ?>
                </nav>
              </div>
          <?php
          }
        } // end if; 
          ?>
      </section>
    </div>
<?php
  }
}
