<?php

/**
 * Elementor App World Widget.
 *
 * @since 1.0.0
 */

class Aarticle_List extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'article-list';
    }

    public function get_title()
    {
        return __('article list', 'liosa');
    }

    public function get_icon()
    {
        return 'eicon-editor-list-ol';
    }

    public function get_categories()
    {
        return ['elementor-widget-be'];
    }



    private function grid_get_all_post_type_categories($post_type)
    {
        $options = array();

        if ($post_type == 'post') {
            $taxonomy = 'category';
        } else {
            $taxonomy = 'product_cat';
        }

        // Get categories for post type.
        $terms = get_terms(
            array(
                'taxonomy' => $taxonomy,
                'hide_empty' => false,
            )
        );

        foreach ($terms as $term) {
            $options[$term->slug] = $term->name;
        }

        return $options;
    }
    private function grid_get_all_post_types()
    {
        $options = array();
        $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

        $args = array(
            'public' => true,
        );

        foreach (get_post_types($args, 'objects') as $post_type) {

            if (!isset($post_type->name)) {
                continue;
            }

            if (!isset($post_type->label)) {
                continue;
            }

            if (in_array($post_type->name, $exclude) === true) {
                continue;
            }

            $options[$post_type->name] = $post_type->label;
        }

        return $options;
    }



    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'elementor-widget-be'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'grid_style',
            [
                'label' => __('Grid Style', 'liosa'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('Layout 1', 'liosa'),
                    '2' => esc_html__('Layout 2', 'liosa'),
                    '3' => esc_html__('Layout 3', 'liosa'),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Title', 'liosa'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'list_title',
            [
                'label' => __('Title', 'elementor-widget-be'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('List Title', 'elementor-widget-be'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'title_more',
            [
                'label' => __('Title More', 'elementor-widget-be'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'number_post',
            [
                'label' => __('ID Category', 'elementor-widget-be'),
                'description' => 'ID Category',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '1',
            ]
        );
        $repeater->add_control(
            'bg_image',
            [
                'label' => __('Choose Image background', 'elementor-widget-be'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'bg_image', // Actually its `image_size`
                'label' => __('Image Resolution', 'elementor-widget-be'),
                'default' => 'large',
                'condition' => [
                    'bg_image[id]!' => '',
                ],
                'separator' => 'none',
            ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => __('Choose Image', 'elementor-widget-be'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'Iconlayoutvid_list',
            [
                'label' => __('Icon', 'liosa'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'grid_post_type',
            [
                'type'    => \Elementor\Controls_Manager::SELECT,
                'label'   => '<i class="fa fa-tag"></i> ' . __('Post Type', 'elementor-widget-be'),
                'default' => 'post',
                'options' => $this->grid_get_all_post_types(),
            ]
        );
        $repeater->add_control(
            'grid_post_categories',
            [
                'type'    => \Elementor\Controls_Manager::SELECT,
                'label'   => '<i class="fa fa-folder"></i> ' . __('Category', 'elementor-widget-be'),
                'options' => $this->grid_get_all_post_type_categories('post'),
                'condition' => [
                    'grid_post_type' => 'post',
                ],
            ]
        );
        $repeater->add_control(
            'grid_order_by',
            [
                'type'    => \Elementor\Controls_Manager::SELECT,
                'label'   => '<i class="fa fa-sort"></i> ' . __('Order by', 'elementor-widget-be'),
                'default' => 'date',
                'options' => [
                    'date'          => __('Date', 'elementor-widget-be'),
                    'title'         => __('Title', 'elementor-widget-be'),
                    'modified'      => __('Modified date', 'elementor-widget-be'),
                    'comment_count' => __('Comment count', 'elementor-widget-be'),
                    'rand'          => __('Random', 'elementor-widget-be'),
                ],
            ]
        );
        $repeater->add_control(
            'grid_content_price',
            [
                'label' => '<i class="fa fa-usd"></i> ' . __('Price', 'elementor-widget-be'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [
                    'section_grid.grid_post_type' => 'product',
                ],
            ]
        );
        $repeater->add_control(
            'grid_items',
            [
                'type'        => \Elementor\Controls_Manager::NUMBER,
                'label'       => '<i class="fa fa-th-large"></i> ' . __('Items', 'elementor-widget-be'),
                'placeholder' => __('How many items?', 'elementor-widget-be'),
                'default'     => 5,
            ]
        );
        $repeater->add_control(
            'show_more',
            [
                'label' => __('Show more', 'elementor-widget-be'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'your-plugin'),
                'label_off' => __('Hide', 'your-plugin'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
            'website_link',
            [
                'label' => __('Link More', 'elementor-widget-be'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'elementor-widget-be'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'list',
            [
                'label' => __('Repeater List', 'elementor-widget-be'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __('Title #1', 'elementor-widget-be'),
                        'list_content' => __('Item content. Click the edit button to change this text.', 'elementor-widget-be'),
                    ],
                    [
                        'list_title' => __('Title #2', 'elementor-widget-be'),
                        'list_content' => __('Item content. Click the edit button to change this text.', 'elementor-widget-be'),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'style_section_3',
            [
                'label' => __('color', 'liosa'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_Color_vid',
            [
                'label' => __('text Color title', 'liosa'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => \Elementor\Scheme_Color::get_type(),
                    'value' => \Elementor\Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'background_Color_vid',
            [
                'label' => __('background Color', 'liosa'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => \Elementor\Scheme_Color::get_type(),
                    'value' => \Elementor\Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Iconlayoutvid',
            [
                'label' => __('Icon', 'liosa'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->end_controls_section();
    }



    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $grid_style = $settings['grid_style'];
        if (1 == $grid_style) {

            include(__DIR__ . '/list/layout-1.php');
        } elseif (2 == $grid_style) {

            include(__DIR__ . '/list/layout-2.php');
        } elseif (3 == $grid_style) {

            include(__DIR__ . '/list/layout-3.php');
        }
        wp_reset_postdata();
    }
}
