<?php

/**
 * Elementor Box Content Responsive Widget.
 *
 */

use \Elementor\Group_Control_Image_Size;


class Contact extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'contact';
  }

  public function get_title()
  {
    return __('تماس با ما', 'liosa');
  }

  public function get_icon()
  {
    return 'eicon-form-horizontal';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }
  protected function _register_controls()
  {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', 'liosa'),
      ]
    );
  }


  protected function render()
  {
    $settings = $this->get_settings(); ?>
    <div class="box-center-form">
      <form id="contactForm">
        <p class="form-row">
          <label for="contactName">نام شما:</label>
          <input type="text" name="contactName" id="contactName" value="" />
        </p>
        <p class="form-row">
          <label for="email">ایمیل شما:</label>
          <input type="text" name="email" id="email" value="" />
        </p>
        <p class="form-row text_p_form">
          <label for="commentsText">پیام:</label>
          <textarea name="commentsText" id="commentsText" rows="7" cols="30"></textarea>
        </p>
        <p class="form-row">
          <input class="button" type="submit" value="ارسال ایمیل"></input>
        </p>
        <input type="hidden" name="submitted" id="submitted" value="ارسال ایمیل" />
        <p id="status" class="form-row"></p>
      </form>
    </div>
<?php
  }
}
