<?php

/**
 * Elementor Header Box Widget.
 *
 */

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Image_Size;


class Dimag_Sidbar extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'dimag-sidbar';
  }

  public function get_title()
  {
    return __(' sidbar', 'liosa');
  }

  public function get_icon()
  {
    return 'eicon-sidebar';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }


  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }

  protected function _register_controls()
  {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', 'liosa'),
      ]
    );
    $this->add_control(
      'grid_style',
      [
        'label' => __('Grid Style', 'liosa'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('Layout 1', 'liosa'),
          '2' => esc_html__('Layout 2', 'liosa'),
          '3' => esc_html__('Layout 3', 'liosa'),
        ],
      ]
    );
    $this->add_control(
      'title',
      [
        'label' => __('Title', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('Title More', 'liosa'),
        'type' => \Elementor\Controls_Manager::WYSIWYG,
        'default' => __('Default description', 'liosa'),
        'placeholder' => __('Type your description here', 'liosa'),
      ]
    );
    $this->add_control(
      'grid_post_type',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-tag"></i> ' . __('Post Type', 'liosa'),
        'default' => 'post',
        'options' => $this->grid_get_all_post_types(),
      ]
    );
    $this->add_control(
      'grid_items',
      [
        'type'        => \Elementor\Controls_Manager::NUMBER,
        'label'       => '<i class="fa fa-th-large"></i> ' . __('Items', 'liosa'),
        'placeholder' => __('How many items?', 'liosa'),
        'default'     => 14,
      ]
    );

    // Post categories.
    $this->add_control(
      'grid_post_categories',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-folder"></i> ' . __('Category', 'liosa'),
        'options' => $this->grid_get_all_post_type_categories('post'),
        'condition' => [
          'grid_post_type' => 'post',
        ],
      ]
    );
    $this->add_control(
      'show_more',
      [
        'label' => __('Show more', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'grid_pagination',
      [
        'label' => '<i class="fa fa-arrow-circle-right"></i> ' . __('Pagination', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => '',
      ]
    );
    // Order by.
    $this->add_control(
      'grid_order_by',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-sort"></i> ' . __('Order by', 'liosa'),
        'default' => 'date',
        'options' => [
          'date'          => __('Date', 'liosa'),
          'title'         => __('Title', 'liosa'),
          'modified'      => __('Modified date', 'liosa'),
          'comment_count' => __('Comment count', 'liosa'),
          'rand'          => __('Random', 'liosa'),
        ],
      ]
    );

    // Price.
    $this->add_control(
      'grid_content_price',
      [
        'label' => '<i class="fa fa-usd"></i> ' . __('Price', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes',
        'condition' => [
          'section_grid.grid_post_type' => 'product',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_style',
      [
        'label' => __('Style', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->end_controls_section();
  }
  private function grid_pagination_section()
  {
    $this->start_controls_section(
      'section_grid_pagination',
      [
        'label'     => __('Pagination', 'liosa'),
        'condition' => [
          'section_grid.grid_pagination' => 'yes',
        ],
      ]
    );

    // Pagination alignment.
    $this->add_responsive_control(
      'grid_pagination_alignment',
      [
        'label'     => __('Alignment', 'liosa'),
        'type'      => \Elementor\Controls_Manager::CHOOSE,
        'options'   => [
          'left'    => [
            'title' => __('Left', 'liosa'),
            'icon'  => 'fa fa-align-left',
          ],
          'center'  => [
            'title' => __('Center', 'liosa'),
            'icon'  => 'fa fa-align-center',
          ],
          'right'   => [
            'title' => __('Right', 'liosa'),
            'icon'  => 'fa fa-align-right',
          ],
        ],
        'default'   => 'center',
        'tablet_default'   => 'center',
        'mobile_default'   => 'center',
        'selectors' => [
          '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'text-align: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_section();
  }
  private function grid_pagination_style_section()
  {
    // Tab.
    $this->start_controls_section(
      'section_grid_pagination_style',
      [
        'label' => __('Pagination', 'liosa'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'section_grid.grid_pagination' => 'yes',
        ],
      ]
    );

    // Image margin.
    $this->add_control(
      'grid_pagination_style_margin',
      [
        'label'      => __('Margin', 'liosa'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors'  => [
          '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_1',
      [
        'label' => __('color layout one', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color_1one',
      [
        'label' => __('Color text author', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_2112',
      [
        'label' => __('background text author', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#e0d4d4',
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_2113',
      [
        'label' => __('background title', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#eee',
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings();
    $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
    $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';

    $args = array();
    $grid_style = $settings['grid_style'];
    $args['post_status'] = 'publish';
    $args['ignore_sticky_posts'] = 1;
    if (!empty($settings['grid_post_type']) && post_type_exists($settings['grid_post_type'])) {
      $args['post_type'] = $settings['grid_post_type'];
    }
    if (!empty($settings['grid_post_categories']) && $settings['grid_post_type'] == 'post') {
      $args['category_name'] = $settings['grid_post_categories'];
    }
    if (!empty($settings['grid_product_categories']) && $settings['grid_post_type'] == 'product') {
      $args['tax_query'] = array(
        'relation' => 'AND',
        array(
          'taxonomy' => 'product_cat',
          'field' => 'slug',
          'terms' => $settings['grid_product_categories'],
        ),
      );
    }
    if (!empty($settings['grid_items']) && intval($settings['grid_items']) == $settings['grid_items']) {
      $args['posts_per_page'] = $settings['grid_items'];
    }
    if (!empty($settings['grid_order_by'])) {
      $args['orderby'] = $settings['grid_order_by'];
    }
    if (!empty($settings['grid_pagination'])) {
      $paged         = get_query_var('paged');
      if (empty($paged)) {
        $paged         = get_query_var('page');
      }
      $args['paged'] = $paged;
    }
    $query = new \WP_Query($args);
    if ($query->have_posts()) {

      if (1 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-1.php');
      } elseif (2 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-2.php');
      } elseif (3 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-3.php');
      }
    } // end if; 

  }
}
