<?php

/**
 * Elementor Header Box Widget.
 *
 */

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Image_Size;


class Header_Box extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'header-box';
  }

  public function get_title()
  {
    return __('Header Box', 'liosa');
  }

  public function get_icon()
  {
    return 'eicon-inner-section';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function wpcap_get_all_post_categories($post_type)
  {

    $options = array();

    $taxonomy = 'category';

    if (!empty($taxonomy)) {
      // Get categories for post type.
      $terms = get_terms(
        array(
          'taxonomy'   => $taxonomy,
          'hide_empty' => false,
        )
      );
      if (!empty($terms)) {
        foreach ($terms as $term) {
          if (isset($term)) {
            if (isset($term->slug) && isset($term->name)) {
              $options[$term->slug] = $term->name;
            }
          }
        }
      }
    }

    return $options;
  }

  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }

  protected function _register_controls()
  {
    $this->start_controls_section(
      'section_layout',
      [
        'label' => esc_html__('Layout', 'liosa'),
      ]
    );
    $this->add_control(
      'grid_style',
      [
        'label' => __('Grid Style', 'liosa'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('Layout 1', 'liosa'),
          '2' => esc_html__('Layout 2', 'liosa'),
          '3' => esc_html__('Layout 3', 'liosa'),
          '4' => esc_html__('Layout 4', 'liosa'),
          '5' => esc_html__('Layout 5', 'liosa'),
          '6' => esc_html__('Layout 6', 'liosa'),
          '7' => esc_html__('Layout 7', 'liosa'),
          '8' => esc_html__('Layout 8', 'liosa'),
          '9' => esc_html__('Layout 9', 'liosa'),
          '10' => esc_html__('Layout 10', 'liosa'),

        ],
      ]
    );
    $this->add_control(
      'title',
      [
        'label' => __('Title', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('Title More', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );

    $this->add_control(
      'meta_data',
      [
        'label' => __('Meta Data', 'liosa'),
        'label_block' => true,
        'type' => \Elementor\Controls_Manager::SELECT2,
        'default' => ['date', 'comments'],
        'multiple' => true,
        'options' => [
          'author' => __('Author', 'liosa'),
          'date' => __('Date', 'liosa'),
          'categories' => __('Categories', 'liosa'),
          'comments' => __('Comments', 'liosa'),
        ],
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'meta_separator',
      [
        'label' => __('Separator Between', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '/',
        'selectors' => [
          '{{WRAPPER}} .wpcap-grid-container .wpcap-post .post-grid-meta span + span:before' => 'content: "{{VALUE}}"',
        ],
        'condition' => [
          'meta_data!' => [],
        ],
      ]
    );
    $this->add_control(
      'posts_per_page',
      [
        'label' => __('Posts Per Page', 'liosa'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'default' => 5,
      ]
    );
    // Post categories
    $this->add_control(
      'post_categories',
      [
        'label'       => __('Categories', 'liosa'),
        'label_block' => true,
        'type'        => \Elementor\Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => $this->wpcap_get_all_post_categories('post'),

      ]
    );

    $this->add_control(
      'advanced',
      [
        'label' => __('Advanced', 'liosa'),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );

    $this->add_control(
      'orderby',
      [
        'label' => __('Order By', 'liosa'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'post_date',
        'options' => [
          'post_date' => __('Date', 'liosa'),
          'post_title' => __('Title', 'liosa'),
          'rand' => __('Random', 'liosa'),
        ],
      ]
    );

    $this->add_control(
      'order',
      [
        'label' => __('Order', 'liosa'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'desc',
        'options' => [
          'asc' => __('ASC', 'liosa'),
          'desc' => __('DESC', 'liosa'),
        ],
      ]
    );
    $this->add_control(
      'show_more',
      [
        'label' => __('Show more', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'layout_2',
      [
        'label' => esc_html__('Layout 2', 'liosa'),
      ]
    );
    $this->add_control(
      'titlelayout_2',
      [
        'label' => __('Title', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title2layout_2',
      [
        'label' => __('Title two', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'titlelayouttree',
      [
        'label' => __('Title three', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'bg_image',
      [
        'label' => __('Choose Image', 'liosa'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'dynamic' => [
          'active' => true,
        ],
        'default' => [],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Image_Size::get_type(),
      [
        'name' => 'bg_image',
        'label' => __('Image Resolution', 'liosa'),
        'default' => 'large',
        'condition' => [
          'bg_image[id]!' => '',
        ],
        'separator' => 'none',
      ]
    );

    $this->add_control(
      'show_image',
      [
        'label' => __('Image', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'default' => 'yes',
        'separator' => 'before',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Image_Size::get_type(),
      [
        'name' => 'post_thumbnail',
        'exclude' => ['custom'],
        'default' => 'full',
        'prefix_class' => 'post-thumbnail-size-',
        'condition' => [
          'show_image' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();
    $repeater = new \Elementor\Repeater();
    $this->start_controls_section(
      'layout_4',
      [
        'label' => __('Layout 4', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater->add_control(
      'list_title',
      [
        'label' => __('Title', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('List Title', 'liosa'),
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'icon_menu',
      [
        'label' => __('Icon', 'text-domain'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-star',
          'library' => 'solid',
        ],
      ]
    );
    $repeater->add_control(
      'link_menu_item',
      [
        'label' => __('Link menu', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $repeater->add_control(
      'list_color_hover',
      [
        'label' => __('Color hover', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}'
        ],
      ]
    );
    $repeater->add_control(
      'list_color',
      [
        'label' => __('Color item', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#6b7074',
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'list',
      [
        'label' => __('Repeater List', 'liosa'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'list_title' => __('Title #1', 'liosa'),
            'list_content' => __('Item content. Click the edit button to change this text.', 'liosa'),
          ],
          [
            'list_title' => __('Title #2', 'liosa'),
            'list_content' => __('Item content. Click the edit button to change this text.', 'liosa'),
          ],
        ],
        'title_field' => '{{{ list_title }}}',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'advertising',
      [
        'label' => __('Advertising', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'image_baneer',
      [
        'label' => __('Choose Image baneer', 'liosa'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'link_image_baneer',
      [
        'label' => __('Link Image baneer', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'image_sid',
      [
        'label' => __('Choose Image sidbar', 'liosa'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'link_image_sid',
      [
        'label' => __('Link Image sidbar', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'image_sid_2',
      [
        'label' => __('Choose Image sidbar', 'liosa'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'link_image_sid_2',
      [
        'label' => __('Link Image sidbar', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'image_sid_3',
      [
        'label' => __('Choose Image sidbar', 'liosa'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'link_image_sid_3',
      [
        'label' => __('Link Image sidbar', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'image_sid_4',
      [
        'label' => __('Choose Image sidbar', 'liosa'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'link_image_sid_4',
      [
        'label' => __('Link Image sidbar', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_1',
      [
        'label' => __('color layout one', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color_1one',
      [
        'label' => __('Color text author', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_2112',
      [
        'label' => __('background text author', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_2',
      [
        'label' => __('color layout two', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color_11',
      [
        'label' => __('title Color one', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_21',
      [
        'label' => __('title Color two and three', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_3',
      [
        'label' => __('color layout tree', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'background_Color_vid',
      [
        'label' => __('background Color', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'Iconlayoutvid',
      [
        'label' => __('Icon', 'liosa'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-star',
          'library' => 'solid',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_4',
      [
        'label' => __('checkbox', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'show_views',
      [
        'label' => __('Show views', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'show_author',
      [
        'label' => __('Show author', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->end_controls_section();
  }
  protected function render($instance = [])
  {
    $settings = $this->get_settings_for_display();
    $bg_image = '';
    if (!empty($settings['bg_image']['id'])) {
      $bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image']['id'], 'bg_image', $settings);
    } elseif (!empty($settings['bg_image']['url'])) {
      $bg_image = $settings['bg_image']['url'];
    }
    if (empty($bg_image) && 'classic' == $settings) {
      $print_bg = false;
    }
    if (!empty($bg_image)) {
      $this->add_render_attribute('background_image', 'style', [
        'background-image: url(' . $bg_image . ');',
      ]);
    }
    $settings = $this->get_settings();
    if (!empty($settings['grid_pagination'])) {
      $paged         = get_query_var('paged');
      if (empty($paged)) {
        $paged         = get_query_var('page');
      }
      $args['paged'] = $paged;
    }
    if (empty($settings['title']) && empty($settings['description']) && empty($settings['button']) && 'none' == $settings) {
      $print_content = false;
    }
    $grid_style = $settings['grid_style'];

    $posts_per_page = (!empty($settings['posts_per_page']) ?  $settings['posts_per_page'] : 3);
    $cats = is_array($settings['post_categories']) ? implode(',', $settings['post_categories']) : $settings['post_categories'];
    $query_args = array(
      'posts_per_page'     => absint($posts_per_page),
      'no_found_rows'      => true,
      'post__not_in'          => get_option('sticky_posts'),
      'ignore_sticky_posts'   => true,
      'category_name'     => $cats
    );
    // Order by.
    if (!empty($settings['orderby'])) {
      $query_args['orderby'] = $settings['orderby'];
    }
    // Order .
    if (!empty($settings['order'])) {
      $query_args['order'] = $settings['order'];
    }
    $all_posts = new \WP_Query($query_args);

    if ($all_posts->have_posts()) :

      if (10 == $grid_style) {

        include(__DIR__ . '/layouts/layout-10.php');
      } elseif (9 == $grid_style) {

        include(__DIR__ . '/layouts/layout-9.php');
      } elseif (8 == $grid_style) {

        include(__DIR__ . '/layouts/layout-8.php');
      } elseif (7 == $grid_style) {

        include(__DIR__ . '/layouts/layout-7.php');
      } elseif (6 == $grid_style) {

        include(__DIR__ . '/layouts/layout-6.php');
      } elseif (5 == $grid_style) {

        include(__DIR__ . '/layouts/layout-5.php');
      } elseif (4 == $grid_style) {

        include(__DIR__ . '/layouts/layout-4.php');
      } elseif (3 == $grid_style) {

        include(__DIR__ . '/layouts/layout-3.php');
      } elseif (2 == $grid_style) {

        include(__DIR__ . '/layouts/layout-2.php');
      } elseif (1 == $grid_style) {

        include(__DIR__ . '/layouts/layout-1.php');
      }
      wp_reset_postdata();
    endif;
  }

  protected function render_meta()
  {
    $settings = $this->get_settings();
    $meta_data = $settings['meta_data'];
    if (empty($meta_data)) {
      return;
    }
?>
    <div class="post-grid-meta">
      <?php
      if (in_array('date', $meta_data)) { ?>
        <span class="post-author"><?php echo apply_filters('the_date', get_the_date(), get_option('date_format'), '', ''); ?></span>
      <?php
      }

      if (in_array('categories', $meta_data)) {
        $categories_list = get_the_category_list(esc_html__(', ', 'liosa'));

        if ($categories_list) {
          printf('<span class="post-categories">%s</span>', $categories_list); // WPCS: XSS OK.
        }
      }

      if (in_array('comments', $meta_data)) { ?>
        <span class="post-comments"><?php comments_number(); ?></span>

      <?php
      }
      ?>
    </div>
    <?php

  }
  protected function render_thumbnail()
  {

    $settings = $this->get_settings();

    $show_image = $settings['show_image'];

    if ('yes' !== $show_image) {
      return;
    }

    $post_thumbnail_size = $settings['post_thumbnail_size'];

    if (has_post_thumbnail()) :  ?>
      <div class="post-grid-thumbnail">
        <a href="<?php the_permalink(); ?>">
          <?php the_post_thumbnail($post_thumbnail_size); ?>
        </a>
      </div>
<?php endif;
  }
}
