<?php
defined( 'ABSPATH' ) || exit();
class ASG_Megamenu_Walker extends Walker_Nav_Menu {
	public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
 
		if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
			$t = '';
			$n = '';
		} else {
			$t = "\t";
			$n = "\n";
		}
		$indent = ( $depth ) ? str_repeat( $t, $depth ) : '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;

		$extra_ouput = "";
		/// 
		if( $this->is_megamenu( $item, $depth ) && $depth == 0 ){
			//echo '<pre>' .print_r( $item ,1 ); 
			$args->has_children = true;
			if( $item->mega_data['customwidth'] == 0 ){
				$classes[] = "has-mega-menu has-fullwidth";
			}elseif( $item->mega_data['customwidth'] == 2 ) {
				$classes[] = "has-mega-menu has-stretchwidth";
			} else {
				$classes[] = "has-mega-menu";
			}
			$extra_ouput = $this->render_megamenu_elementor( $item, $args, $depth );
		}
		$args = apply_filters( 'nav_menu_item_args', $args, $item, $depth );
		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';
		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args, $depth );
		$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

		$output .= $indent . '<li' . $id . $class_names .'>';

		$atts = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target )     ? $item->target     : '';
		$atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
		$atts['href']   = ! empty( $item->url )        ? $item->url        : '';
		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}
		/**
		 * Megamenu info
		 */
		$icon  = $desc = $badge = $arrow = '';

		if( isset($item->mega_data) && !empty($item->mega_data) ){ 
			if ( ! empty( $item->mega_data['icon'] ) ) {
				$icon = asg_get_icon_html( $item->mega_data['icon'], $item->mega_data );
			}
			
			if ( ! empty( $item->mega_data['badge_title'] ) ) {
				$badge = asg_get_badge_html( $item->mega_data['badge_title'], $item->mega_data );
			}

			if ( ! empty( $item->mega_data['description'] ) ) {
				$desc = "<span class=\"menu-desc\">".$item->mega_data['description']."</span>";
			}
		}
		
		$title = apply_filters( 'the_title', $item->title, $item->ID );
		$title = sprintf(
			'%1$s<span class="menu-title">%2$s%3$s</span>%4$s%5$s',
			$icon,
			$title,
			$desc,
			$badge,
			$arrow
		);
		$title = apply_filters( 'nav_menu_item_title', $title, $item, $args, $depth );

		$item_output = '<a'. $attributes .'>';
		$item_output .=  $title ;
		$item_output .= '</a>';
		$item_output .= $extra_ouput; 
		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}
	public function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output ) {
		if ( ! $element ) {
			return;
		}	
 		// echo '<pre>'.print_r( $element ,1 );die;
 		$element->mega_data   = asg_get_megamenu_item_data( $element->ID );

		if( $this->is_megamenu($element, $depth) && $depth == 0 ) {
		  	$id_field = $this->db_fields['id'];
		  	if( isset($children_elements[$element->$id_field]) && is_array($children_elements[$element->$id_field]) ) {
			  	foreach( $children_elements[$element->$id_field] as $_item ) {
			  		$children_elements[$_item->ID] = array();	
			  	}

              	$children_elements[$element->$id_field] = array();
            }  	
        }
		parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	}

	/**
	 * Check megamenu for only item at depth = 0
	 */
	public function is_megamenu( $item, $depth ) { 
		if( $depth == 0 ){
			return ( isset($item->mega_data['enabled']) && !empty( $item->mega_data['enabled'] ) );
		}
		return false;
	}

	/**
	 * Display megamenu content which was rendered elementor
	 */
	public function render_megamenu_elementor( $item, $args, $depth ){
		$output = "";
		if ( class_exists( 'Elementor\Plugin' ) ) {
			$post_id     = asg_get_post_related_menu( $item->ID );

			$elementor = Elementor\Plugin::instance();
			$content   = $elementor->frontend->get_builder_content_for_display( $post_id );

			// Default class.

			$style = "";

			if( $item->mega_data['subwidth'] && $item->mega_data['customwidth'] == 2 ) {
				$classes = array( 'sub-menu', 'mega-menu', 'mega-stretchwidth' );
			} elseif ($item->mega_data['subwidth'] && $item->mega_data['customwidth'] == 0) {
				$classes = array( 'sub-menu', 'mega-menu', 'mega-fullwidth' );
			}else {
				$style .= 'style="width:'.$item->mega_data['subwidth'].'px;max-width:'.$item->mega_data['subwidth'].'px"';
				$classes = array( 'sub-menu', 'mega-menu', 'custom-subwidth' );
			}
			$class_names = join( ' ', apply_filters( 'nav_menu_submenu_css_class', $classes, $args, $depth ) );
			$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';
			
			$output = "<ul $class_names  data-subwidth=\"".$item->mega_data['subwidth']."\"><li class=\"mega-menu-item\" ".$style.">".do_shortcode( $content )."</li></ul>";
		}

		return $output;
    }
}
