<?php

/*
 * Template Name: single three
 * Template Post Type: post
 */

get_header();
dynamic_sidebar('sideades_two');
$show_article_popular  = ot_get_option('show_article_popular', true);
if ($show_article_popular  == 'on') :
    get_template_part('themeplat/content/article/article-popular', 'popular');
endif;
?>
<div class="content">
    <div data-sticky_parent>
        <div id="asd" class="container middle">
            <div class="row">
                <div class="col-sm-12 col-lg-9 pal_0">
                    <div class="main tall single-post-3 main-content maincontent home-col">
                        <section class="home-col solid-home single-content">
                            <div class="article-header">
                                <?php if (ot_get_option('advertising_post_top')) : ?>
                                    <div class="am__header-inside-logo">
                                        <a href="<?php echo ot_get_option('advertising_post_top_link'); ?>" rel="nofollow" target="_blank">
                                            <img src="<?php echo ot_get_option('advertising_post_top'); ?>" style="float: left;margin-top: 7px;">
                                        </a>
                                    </div>
                                    <?php
                                endif;
                                if (have_posts()) : while (have_posts()) : the_post(); ?>
                                        <h1><?php the_title(); ?></h1>
                                        <div class="rightsidebar col-md-12" style="padding: 0;">
                                            <div class="author-avatar">
                                                <?php
                                                echo get_avatar(get_the_author_meta('ID'), 32); ?>
                                            </div>
                                            <div class="author-details">
                                                <div itemprop="author" class="author-details-row1">
                                                    <?php _e('author ', 'liosa'); ?>:
                                                    <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                        <span itemprop="name" class="item__details--author"><?php the_author_meta('display_name'); ?></span>
                                                    </a>
                                                    __
                                                    <span>
                                                        <time><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                                                    </span>
                                                    <?php if (info_content_get_meta('info_content_version')) : ?>
                                                        <span class="version_undefined">
                                                            <?php _e('Study time ', 'liosa'); ?>:
                                                            <span><?php echo info_content_get_meta('info_content_version'); ?></span>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                        </div>
                                <?php
                                    endwhile;
                                endif;
                                ?>
                            </div>
                            <figure class="article_image">
                                <?php
                                if (has_post_thumbnail()) : ?>
                                    <a href="<?php the_permalink() ?>" title="<?php the_title() ?>">
                                        <?php the_post_thumbnail('singlethumbnail') ?>
                                    </a>
                                <?php else : ?>
                                    <a href="<?php the_permalink() ?>" title="<?php the_title() ?>">
                                        <img src="<?php bloginfo('template_url'); ?>/assets/image/search-bar.gif" width="60" height="60" alt="<?php _e('Image not found', 'liosa'); ?>" title="<?php _e('Image not found', 'liosa'); ?>">
                                    </a>
                                <?php endif ?>
                            </figure>
                            <div class="article-social-item">
                                <span class="share-handler">
                                    <i class="bf-icon fal fa-share-alt" aria-hidden="true"></i><b class="text"><?php _e('share', 'liosa'); ?></b>
                                </span>
                                <a href="https://twitter.com/share?text=text goes here&url=<?php the_permalink(); ?> " target="_blank" title="<?php _e('Share in twitter', 'liosa'); ?>" rel="nofollow" class="social twitter">
                                    <i class="fab fa-twitter"></i>
                                </a>
                                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?> " target="_blank" title="<?php _e('Share in facebook', 'liosa'); ?>" rel="nofollow" class="social facebook">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                                <a href="https://telegram.me/share/url?url=<?php the_permalink(); ?>&text=<?php the_title(); ?> " target="_blank" title="<?php _e('Share in telegram', 'liosa'); ?>" rel="nofollow" class="social telegram">
                                    <i class="fab fa-telegram-plane"></i>
                                </a>
                                <a href="whatsapp://send?text=<?php the_permalink(); ?>" data-action="share/whatsapp/share" target="_blank" title="<?php _e('Share in whatsapp', 'liosa'); ?>" rel="nofollow" class="social whatsapp">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                                <span class="a-comment-count left">
                                    <i class="fal fa-comments" aria-hidden="true"></i>
                                    <a href="#comments" class="a-comment-count-bubble" data-bind="text: totalCommentsCount"><?php comments_number('0', '1', '%'); ?></a>
                                </span>
                            </div>
                            <?php get_template_part('themeplat/single/main-content', 'maincontent'); ?>
                            <section class="Extra-edge single-entry-cards">
                                <div class="Next-related-content">
                                    <?php get_template_part('themeplat/single/related-posts-list', 'related'); ?>
                                </div>
                            </section>
                            <?php get_template_part('themeplat/single/comment-single', 'single'); ?>
                        </section>
                    </div>
                </div>
                <?php get_sidebar('right'); ?>
            </div>
        </div>
    </div>
</div>
</div>
<?php
get_template_part('themeplat/single/read-more', 'read-more');
get_footer();
?>