<?php
get_header();
dynamic_sidebar('sideades_two');
$show_article_popular  = ot_get_option('show_article_popular', true);
if ($show_article_popular  == 'on') :
  get_template_part('themeplat/content/article/article-popular', 'popular');
endif;
?>
<div class="content">
  <div data-sticky_parent>
    <div id="asd" class="container middle">
      <div class="row">
        <?php get_sidebar('right'); ?>
        <div class="col-sm-12 col-md-8 col-lg-8 col-xl-6" style="padding: 0;">
          <div class="main tall main-content maincontent home-col">
            <section class="home-col solid-home single-content">
              <div class="article-header">
                <div class="a-comment-block">
                  <span class="a-comment-count">
                    <a href="#comments" class="a-comment-count-bubble" data-bind="text: totalCommentsCount"><?php comments_number('0', '1', '%'); ?></a>
                  </span>
                </div>
                <div class="catgroup">
                  <?php the_category(); ?>
                </div>
                <h1><?php the_title(); ?></h1>
                <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                    <div class="rightsidebar col-md-6" style="padding-right: 0;">
                      <div class="author-avatar">
                        <?php echo get_avatar(get_the_author_meta('ID'), 68); ?>
                      </div>
                      <div class="author-details">
                        <div itemprop="author" class="author-details-row1">
                          <?php _e('author ', 'liosa'); ?>:
                          <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                            <span itemprop="name" class="item__details--author"><?php the_author_meta('display_name'); ?></span>
                          </a>
                        </div>
                        <div class="author-details-row2">
                          <span>
                            <time><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                          </span>
                        </div>
                      </div>
                    </div>
                <?php
                  endwhile;
                endif;
                ?>
              </div>
              <figure class="article_image">
                <?php
                if (has_post_thumbnail()) : ?>
                  <a href="<?php the_permalink() ?>" title="<?php the_title() ?>">
                    <?php the_post_thumbnail('singlethumbnail') ?>
                  </a>
                <?php else : ?>
                  <a href="<?php the_permalink() ?>" title="<?php the_title() ?>">
                    <img src="<?php bloginfo('template_url'); ?>/assets/image/search-bar.gif" width="60" height="60" alt="<?php _e('Image not found', 'liosa'); ?>" title="<?php _e('Image not found', 'liosa'); ?>">
                  </a>
                <?php endif ?>
              </figure>
              <div class="article-social-item">
                <a href="https://twitter.com/share?text=text goes here&url=<?php the_permalink(); ?> " target="_blank" title="<?php _e('Share in twitter', 'liosa'); ?>" rel="nofollow" class="social twitter">
                  <i class="fab fa-twitter"></i>
                  <span><?php _e('twitter', 'liosa'); ?></span>
                </a>
                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?> " target="_blank" title="<?php _e('Share in facebook', 'liosa'); ?>" rel="nofollow" class="social facebook">
                  <i class="fab fa-facebook-f"></i>
                  <span><?php _e('facebook', 'liosa'); ?></span>
                </a>
                <a href="https://telegram.me/share/url?url=<?php the_permalink(); ?>&text=<?php the_title(); ?> " target="_blank" title="<?php _e('Share in telegram', 'liosa'); ?>" rel="nofollow" class="social telegram">
                  <i class="fab fa-telegram-plane"></i>
                  <span><?php _e('telegram', 'liosa'); ?></span>
                </a>
                <a href="whatsapp://send?text=<?php the_permalink(); ?>" data-action="share/whatsapp/share" target="_blank" title="<?php _e('Share in whatsapp', 'liosa'); ?>" rel="nofollow" class="social whatsapp">
                  <i class="fab fa-whatsapp"></i>
                  <span><?php _e('whatsapp', 'liosa'); ?></span>
                </a>
              </div>
              <?php get_template_part('themeplat/single/main-content', 'maincontent'); ?>
              <section class="Extra-edge single-entry-cards">
                <div class="Next-related-content">
                  <?php
                  get_template_part('themeplat/single/related-posts-list', 'related');
                  ?>
                </div>
              </section>
              <?php get_template_part('themeplat/single/comment-single', 'single'); ?>
            </section>
          </div>
        </div>
        <?php get_sidebar('left'); ?>
      </div>
    </div>
  </div>
</div>
</div>
<?php
get_template_part('themeplat/single/read-more', 'read-more');
get_footer();
?>